import { jsx, jsxs } from "react/jsx-runtime";
import * as Popover from "@radix-ui/react-popover";
import { USER_COLORS, track, useContainer, useEditor } from "@tldraw/editor";
import React, { useCallback, useRef, useState } from "react";
import { useUiEvents } from "../../context/events.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
const UserPresenceColorPicker = track(function UserPresenceColorPicker2() {
  const editor = useEditor();
  const container = useContainer();
  const msg = useTranslation();
  const trackEvent = useUiEvents();
  const rPointing = useRef(false);
  const [isOpen, setIsOpen] = useState(false);
  const handleOpenChange = useCallback((isOpen2) => {
    setIsOpen(isOpen2);
  }, []);
  const value = editor.user.getColor();
  const onValueChange = useCallback(
    (item) => {
      editor.user.updateUserPreferences({ color: item });
      trackEvent("set-color", { source: "people-menu" });
    },
    [editor, trackEvent]
  );
  const {
    handleButtonClick,
    handleButtonPointerDown,
    handleButtonPointerEnter,
    handleButtonPointerUp
  } = React.useMemo(() => {
    const handlePointerUp = () => {
      rPointing.current = false;
      window.removeEventListener("pointerup", handlePointerUp);
    };
    const handleButtonClick2 = (e) => {
      const { id } = e.currentTarget.dataset;
      if (!id) return;
      if (value === id) return;
      onValueChange(id);
    };
    const handleButtonPointerDown2 = (e) => {
      const { id } = e.currentTarget.dataset;
      if (!id) return;
      onValueChange(id);
      rPointing.current = true;
      window.addEventListener("pointerup", handlePointerUp);
    };
    const handleButtonPointerEnter2 = (e) => {
      if (!rPointing.current) return;
      const { id } = e.currentTarget.dataset;
      if (!id) return;
      onValueChange(id);
    };
    const handleButtonPointerUp2 = (e) => {
      const { id } = e.currentTarget.dataset;
      if (!id) return;
      onValueChange(id);
    };
    return {
      handleButtonClick: handleButtonClick2,
      handleButtonPointerDown: handleButtonPointerDown2,
      handleButtonPointerEnter: handleButtonPointerEnter2,
      handleButtonPointerUp: handleButtonPointerUp2
    };
  }, [value, onValueChange]);
  return /* @__PURE__ */ jsxs(Popover.Root, { onOpenChange: handleOpenChange, open: isOpen, children: [
    /* @__PURE__ */ jsx(Popover.Trigger, { dir: "ltr", asChild: true, children: /* @__PURE__ */ jsx(
      TldrawUiButton,
      {
        type: "icon",
        className: "tlui-people-menu__user__color",
        style: { color: editor.user.getColor() },
        title: msg("people-menu.change-color"),
        children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "color" })
      }
    ) }),
    /* @__PURE__ */ jsx(Popover.Portal, { container, children: /* @__PURE__ */ jsx(
      Popover.Content,
      {
        dir: "ltr",
        className: "tlui-menu tlui-people-menu__user__color-picker",
        align: "start",
        side: "left",
        sideOffset: 8,
        children: /* @__PURE__ */ jsx("div", { className: "tlui-buttons__grid", children: USER_COLORS.map((item) => /* @__PURE__ */ jsx(
          TldrawUiButton,
          {
            type: "icon",
            "data-id": item,
            "data-testid": item,
            "aria-label": item,
            "data-state": value === item ? "hinted" : void 0,
            title: item,
            className: "tlui-button-grid__button",
            style: { color: item },
            onPointerEnter: handleButtonPointerEnter,
            onPointerDown: handleButtonPointerDown,
            onPointerUp: handleButtonPointerUp,
            onClick: handleButtonClick,
            children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "color" })
          },
          item
        )) })
      }
    ) })
  ] });
});
export {
  UserPresenceColorPicker
};
//# sourceMappingURL=UserPresenceColorPicker.mjs.map
